/*
 * Decompiled with CFR 0.152.
 */
package views;

import controller.globalCommands.IGlobalCommands;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.MessageFormat;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import org.ctom.hulis.huckel.Energy;
import org.ctom.hulis.huckel.events.BlocDelocalizedEvent;
import org.ctom.hulis.huckel.events.HuckelAtomEvent;
import org.ctom.hulis.huckel.events.HuckelBondEvent;
import org.ctom.hulis.huckel.events.MesomeryEvent;
import org.ctom.hulis.huckel.events.MoleculeEvent;
import org.ctom.hulis.huckel.events.MonoExcitationEvent;
import org.ctom.hulis.huckel.events.StructureDelocalizedEvent;
import org.ctom.hulis.huckel.events.StructureEvent;
import org.ctom.hulis.huckel.events.StructureLocalizedEvent;
import org.ctom.hulis.huckel.listeners.IMesomeryListener;
import org.ctom.hulis.huckel.structures.Structure;
import org.ctom.hulis.huckel.structures.StructureDelocalized;
import util.MyResourceBundle;
import util.ThreadUtils;
import util.languages.LanguageManager;
import views.FrameApp;

public class ToolBarHuckel
extends JPanel
implements IGlobalCommands,
IMesomeryListener {
    public static final int ICON_WIDTH = 28;
    public static final int ICON_HEIGHT = 15;
    private FrameApp app;
    public JToggleButton btAdd = new JToggleButton();
    public JToggleButton btChange = new JToggleButton();
    public JCheckBox btDisplayHxHxy = new JCheckBox();
    public JCheckBox btDisplayCharges = new JCheckBox();
    public JCheckBox btDisplayNum = new JCheckBox();
    public JButton btErase = new JButton();
    public JButton btMoleculeAddElecCharge = new JButton();
    public JButton btMoleculeRemoveElecCharge = new JButton();
    public JToggleButton btMove = new JToggleButton();
    public JButton btQuit = new JButton();
    public JToggleButton btRemove = new JToggleButton();
    public JToggleButton btRenum = new JToggleButton();
    public JToggleButton btRotate = new JToggleButton();
    public JButton btOptimize = new JButton();
    public JButton btCenter = new JButton();
    public JButton btShowResults = new JButton();
    MyResourceBundle bundle;
    public JLabel lblEHuckel = new JLabel();
    public JLabel lblHuckel = new JLabel();
    public JLabel lblTotalCharge = new JLabel();
    private String sCharge = "";
    private String sEnergy = "";

    public ToolBarHuckel(FrameApp app) {
        this.app = app;
        this.updateLanguage();
        this.distribute();
    }

    public void distribute() {
        GridBagLayout repartiteur = new GridBagLayout();
        this.setLayout(repartiteur);
        GridBagConstraints contraintes = new GridBagConstraints();
        this.lblHuckel.setHorizontalAlignment(0);
        this.lblHuckel.setPreferredSize(new Dimension((int)this.getPreferredSize().getWidth(), 55));
        this.lblHuckel.setOpaque(true);
        this.lblHuckel.setBackground(new Color(0, 153, 255));
        contraintes.gridx = 0;
        contraintes.gridy = 0;
        contraintes.insets = new Insets(0, 0, 5, 0);
        contraintes.gridwidth = 4;
        contraintes.gridheight = 2;
        contraintes.weightx = 0.0;
        contraintes.weighty = 0.0;
        contraintes.ipadx = 0;
        contraintes.ipady = 0;
        contraintes.fill = 1;
        contraintes.anchor = 11;
        this.add((Component)this.lblHuckel, contraintes);
        contraintes.insets = new Insets(0, 0, 0, 0);
        contraintes.gridx = 1;
        contraintes.gridy = 2;
        contraintes.gridwidth = 2;
        contraintes.gridheight = 1;
        contraintes.weightx = 0.0;
        contraintes.weighty = 0.0;
        contraintes.ipadx = 0;
        contraintes.ipady = 0;
        contraintes.fill = 2;
        contraintes.anchor = 10;
        this.add((Component)this.btAdd, contraintes);
        contraintes.gridx = 1;
        contraintes.gridy = 3;
        contraintes.insets = new Insets(0, 0, 0, 0);
        contraintes.gridwidth = 2;
        contraintes.gridheight = 1;
        contraintes.weightx = 0.0;
        contraintes.weighty = 0.0;
        contraintes.ipadx = 0;
        contraintes.ipady = 0;
        contraintes.fill = 2;
        contraintes.anchor = 10;
        this.add((Component)this.btChange, contraintes);
        contraintes.gridx = 1;
        contraintes.gridy = 4;
        contraintes.insets = new Insets(0, 0, 0, 0);
        contraintes.gridwidth = 2;
        contraintes.gridheight = 1;
        contraintes.weightx = 0.0;
        contraintes.weighty = 0.0;
        contraintes.ipadx = 0;
        contraintes.ipady = 0;
        contraintes.fill = 2;
        contraintes.anchor = 10;
        this.add((Component)this.btRemove, contraintes);
        contraintes.insets = new Insets(0, 10, 0, 0);
        contraintes.gridx = 1;
        contraintes.gridy = 5;
        contraintes.gridwidth = 2;
        contraintes.gridheight = 1;
        contraintes.weightx = 0.5;
        contraintes.weighty = 0.0;
        contraintes.ipadx = 0;
        contraintes.ipady = 0;
        contraintes.anchor = 21;
        contraintes.fill = 2;
        this.add((Component)this.lblTotalCharge, contraintes);
        contraintes.insets = new Insets(0, 0, 0, 0);
        contraintes.gridx = 1;
        contraintes.gridy = 6;
        contraintes.gridwidth = 1;
        contraintes.gridheight = 1;
        contraintes.weightx = 0.5;
        contraintes.weighty = 0.0;
        contraintes.ipadx = 0;
        contraintes.ipady = 0;
        contraintes.anchor = 10;
        contraintes.fill = 0;
        this.add((Component)this.btMoleculeAddElecCharge, contraintes);
        contraintes.insets = new Insets(0, 0, 0, 0);
        contraintes.gridx = 2;
        contraintes.gridy = 6;
        contraintes.gridwidth = 1;
        contraintes.gridheight = 1;
        contraintes.weightx = 0.5;
        contraintes.weighty = 0.0;
        contraintes.ipadx = 0;
        contraintes.ipady = 0;
        contraintes.anchor = 10;
        contraintes.fill = 0;
        this.add((Component)this.btMoleculeRemoveElecCharge, contraintes);
        contraintes.insets = new Insets(0, 0, 0, 0);
        contraintes.gridx = 1;
        contraintes.gridy = 7;
        contraintes.gridwidth = 1;
        contraintes.gridheight = 1;
        contraintes.weightx = 0.5;
        contraintes.weighty = 0.0;
        contraintes.ipadx = 0;
        contraintes.ipady = 0;
        contraintes.anchor = 10;
        contraintes.fill = 0;
        this.add((Component)this.btMove, contraintes);
        contraintes.insets = new Insets(0, 0, 0, 0);
        contraintes.gridx = 2;
        contraintes.gridy = 7;
        contraintes.gridwidth = 1;
        contraintes.gridheight = 1;
        contraintes.weightx = 0.5;
        contraintes.weighty = 0.0;
        contraintes.ipadx = 0;
        contraintes.ipady = 0;
        contraintes.anchor = 10;
        contraintes.fill = 0;
        this.add((Component)this.btRotate, contraintes);
        contraintes.insets = new Insets(0, 0, 0, 0);
        contraintes.gridx = 1;
        contraintes.gridy = 8;
        contraintes.gridwidth = 1;
        contraintes.gridheight = 1;
        contraintes.weightx = 0.5;
        contraintes.weighty = 0.0;
        contraintes.ipadx = 0;
        contraintes.ipady = 0;
        contraintes.fill = 2;
        contraintes.anchor = 10;
        this.add((Component)this.btOptimize, contraintes);
        contraintes.insets = new Insets(0, 0, 0, 0);
        contraintes.gridx = 2;
        contraintes.gridy = 8;
        contraintes.gridwidth = 1;
        contraintes.gridheight = 1;
        contraintes.weightx = 0.5;
        contraintes.weighty = 0.0;
        contraintes.ipadx = 0;
        contraintes.ipady = 0;
        contraintes.fill = 2;
        contraintes.anchor = 10;
        this.add((Component)this.btCenter, contraintes);
        contraintes.insets = new Insets(0, 0, 0, 0);
        contraintes.gridx = 1;
        contraintes.gridy = 9;
        contraintes.gridwidth = 2;
        contraintes.gridheight = 1;
        contraintes.weightx = 0.0;
        contraintes.weighty = 0.0;
        contraintes.ipadx = 0;
        contraintes.ipady = 0;
        contraintes.fill = 2;
        contraintes.anchor = 10;
        this.add((Component)this.btRenum, contraintes);
        contraintes.insets = new Insets(0, 5, 0, 0);
        contraintes.gridx = 1;
        contraintes.gridy = 10;
        contraintes.gridwidth = 2;
        contraintes.gridheight = 1;
        contraintes.weightx = 0.0;
        contraintes.weighty = 0.0;
        contraintes.ipadx = 0;
        contraintes.ipady = 0;
        contraintes.fill = 2;
        contraintes.anchor = 21;
        this.add((Component)this.btDisplayNum, contraintes);
        contraintes.insets = new Insets(0, 5, 0, 0);
        contraintes.gridx = 1;
        contraintes.gridy = 11;
        contraintes.gridwidth = 2;
        contraintes.gridheight = 1;
        contraintes.weightx = 0.0;
        contraintes.weighty = 0.0;
        contraintes.ipadx = 0;
        contraintes.ipady = 0;
        contraintes.fill = 2;
        contraintes.anchor = 21;
        this.add((Component)this.btDisplayHxHxy, contraintes);
        contraintes.insets = new Insets(0, 5, 0, 0);
        contraintes.gridx = 1;
        contraintes.gridy = 12;
        contraintes.gridwidth = 2;
        contraintes.gridheight = 1;
        contraintes.weightx = 0.0;
        contraintes.weighty = 0.0;
        contraintes.ipadx = 0;
        contraintes.ipady = 0;
        contraintes.fill = 2;
        contraintes.anchor = 21;
        this.add((Component)this.btDisplayCharges, contraintes);
        contraintes.insets = new Insets(0, 10, 0, 0);
        contraintes.gridx = 1;
        contraintes.gridy = 13;
        contraintes.gridwidth = 2;
        contraintes.gridheight = 1;
        contraintes.weightx = 0.0;
        contraintes.weighty = 0.0;
        contraintes.ipadx = 0;
        contraintes.ipady = 0;
        contraintes.fill = 2;
        contraintes.anchor = 21;
        this.add((Component)this.lblEHuckel, contraintes);
        contraintes.insets = new Insets(0, 0, 0, 0);
        contraintes.gridx = 1;
        contraintes.gridy = 14;
        contraintes.gridwidth = 2;
        contraintes.gridheight = 1;
        contraintes.weightx = 0.0;
        contraintes.weighty = 0.0;
        contraintes.ipadx = 0;
        contraintes.ipady = 0;
        contraintes.fill = 2;
        contraintes.anchor = 10;
        this.add((Component)this.btShowResults, contraintes);
        contraintes.insets = new Insets(0, 0, 0, 0);
        contraintes.gridx = 1;
        contraintes.gridy = 15;
        contraintes.gridwidth = 2;
        contraintes.gridheight = 1;
        contraintes.weightx = 0.0;
        contraintes.weighty = 1.0;
        contraintes.ipadx = 0;
        contraintes.ipady = 0;
        contraintes.fill = 2;
        contraintes.anchor = 15;
        this.add((Component)this.btErase, contraintes);
        contraintes.insets = new Insets(0, 0, 0, 0);
        contraintes.gridx = 1;
        contraintes.gridy = 16;
        contraintes.gridwidth = 2;
        contraintes.gridheight = 1;
        contraintes.weightx = 0.0;
        contraintes.weighty = 0.0;
        contraintes.ipadx = 0;
        contraintes.ipady = 0;
        contraintes.fill = 2;
        contraintes.anchor = 15;
        this.add((Component)this.btQuit, contraintes);
    }

    @Override
    public Insets getInsets() {
        return new Insets(10, 0, 10, 0);
    }

    public boolean isCheckedHxHxy() {
        return this.btDisplayHxHxy.isSelected();
    }

    public boolean isCheckedCharges() {
        return this.btDisplayCharges.isSelected();
    }

    public void refresh() {
        this.updateLanguage();
    }

    public void setBackgroundColor(Color bg) {
        super.setBackground(bg);
        this.btDisplayHxHxy.setBackground(bg);
        this.btDisplayCharges.setBackground(bg);
        this.btDisplayNum.setBackground(bg);
    }

    public void setFonts() {
        Font btFont = (Font)this.bundle.getObject("font");
        Font btFont2 = new Font("Helvetica", 0, 11);
        this.lblTotalCharge.setFont(btFont);
        this.lblEHuckel.setFont(btFont2);
        this.btAdd.setFont(btFont);
        this.btDisplayHxHxy.setFont(btFont);
        this.btDisplayCharges.setFont(btFont);
        this.btDisplayNum.setFont(btFont);
        this.btChange.setFont(btFont);
        this.btRemove.setFont(btFont);
        this.btMove.setFont(btFont);
        this.btRotate.setFont(btFont);
        this.btOptimize.setFont(btFont);
        this.btCenter.setFont(btFont);
        this.btRenum.setFont(btFont);
        this.btShowResults.setFont(btFont);
        this.btErase.setFont(btFont);
        this.btQuit.setFont(btFont);
        this.btAdd.setOpaque(false);
        this.btMoleculeAddElecCharge.setOpaque(false);
        this.btMoleculeRemoveElecCharge.setOpaque(false);
        this.btDisplayNum.setOpaque(false);
        this.btDisplayHxHxy.setOpaque(false);
        this.btDisplayCharges.setOpaque(false);
        this.btChange.setOpaque(false);
        this.btRemove.setOpaque(false);
        this.btMove.setOpaque(false);
        this.btRotate.setOpaque(false);
        this.btOptimize.setOpaque(false);
        this.btCenter.setOpaque(false);
        this.btRenum.setOpaque(false);
        this.btShowResults.setOpaque(false);
        this.btErase.setOpaque(false);
        this.btQuit.setOpaque(false);
    }

    public void updateLanguage() {
        this.bundle = LanguageManager.getInstance().getResource("ToolBarHuckel");
        this.sCharge = this.bundle.getString("ktotalcharge");
        this.sEnergy = String.valueOf(this.bundle.getString("kenergy")) + "<sub>" + "tot" + "</sub> = ";
        this.lblHuckel.setText(this.bundle.getString("khuckel"));
        this.btAdd.setText(this.bundle.getString("kbuild"));
        this.btChange.setText(this.bundle.getString("kchange"));
        this.btRemove.setText(this.bundle.getString("kdelete"));
        this.btMove.setIcon(new ImageIcon(new ImageIcon(this.getClass().getClassLoader().getResource(this.bundle.getString("kimgmove"))).getImage().getScaledInstance(28, 15, 4)));
        this.btRotate.setIcon(new ImageIcon(new ImageIcon(this.getClass().getClassLoader().getResource(this.bundle.getString("kimgrotate"))).getImage().getScaledInstance(28, 15, 4)));
        this.btOptimize.setText(this.bundle.getString("koptimize"));
        this.btCenter.setIcon(new ImageIcon(new ImageIcon(this.getClass().getClassLoader().getResource(this.bundle.getString("kimgcenter"))).getImage().getScaledInstance(28, 15, 4)));
        this.btRenum.setText(this.bundle.getString("krenum"));
        this.btShowResults.setText(this.bundle.getString("kresults"));
        this.btErase.setText(this.bundle.getString("keraseall"));
        this.btMoleculeAddElecCharge.setText("-");
        this.btMoleculeRemoveElecCharge.setText("+");
        this.btDisplayHxHxy.setText(this.bundle.getString("kinfos"));
        this.btDisplayCharges.setText(this.bundle.getString("kcharges"));
        this.btDisplayNum.setText(this.bundle.getString("knum"));
        this.btQuit.setText(this.bundle.getString("kquit"));
        this.setFonts();
        this.refreshDelocalizedStructureInfos();
    }

    protected void refreshDelocalizedStructureInfos() {
        if (this.app.getCurrentMesomeryView() != null) {
            StructureDelocalized s = this.app.getCurrentMesomeryView().getMesomery().getDelocalizedStructure();
            if (s != null) {
                int charge = -s.getNbElecCharge();
                Energy totalEnergy = s.getTotalEnergy();
                Object[] args = new Object[]{charge};
                this.lblTotalCharge.setText(MessageFormat.format(this.sCharge, args));
                this.lblEHuckel.setText("<html>" + this.sEnergy + totalEnergy + "</html>");
            } else {
                this.lblTotalCharge.setText(MessageFormat.format(this.sCharge, 0));
                this.lblEHuckel.setText("<html>" + this.sEnergy + "0" + "</html>");
            }
        }
    }

    @Override
    public void mesomeryStructuresSelectionTresholdChanged(MesomeryEvent e) {
    }

    @Override
    public void mesomeryListWeightCalculated(MesomeryEvent e) {
    }

    @Override
    public void mesomeryMethodAdded(MesomeryEvent e) {
    }

    @Override
    public void mesomeryMethodRemoved(MesomeryEvent e) {
    }

    public void handleStructureChanged(Structure s) {
        if (s instanceof StructureDelocalized) {
            this.refreshDelocalizedStructureInfos();
        }
    }

    @Override
    public void mesomeryStructureRemoved(MesomeryEvent e) {
        final MesomeryEvent event = e;
        ThreadUtils.invokeAsSoonAsPossible(new Runnable(){

            @Override
            public void run() {
                ToolBarHuckel.this.handleStructureChanged((Structure)event.getOldValue());
            }
        });
    }

    @Override
    public void mesomeryStructureAdded(MesomeryEvent e) {
    }

    @Override
    public void structureDelocalizedSpinChanged(StructureDelocalizedEvent event) {
    }

    @Override
    public void structureNameChanged(StructureEvent event) {
    }

    @Override
    public void moleculeAtomAdded(MoleculeEvent e) {
        final MoleculeEvent event = e;
        ThreadUtils.invokeAsSoonAsPossible(new Runnable(){

            @Override
            public void run() {
                ToolBarHuckel.this.handleStructureChanged((Structure)event.getSource());
            }
        });
    }

    @Override
    public void moleculeAtomRemoved(MoleculeEvent e) {
        final MoleculeEvent event = e;
        ThreadUtils.invokeAsSoonAsPossible(new Runnable(){

            @Override
            public void run() {
                ToolBarHuckel.this.handleStructureChanged((Structure)event.getSource());
            }
        });
    }

    @Override
    public void moleculeAtomReplaced(MoleculeEvent e) {
        final MoleculeEvent event = e;
        ThreadUtils.invokeAsSoonAsPossible(new Runnable(){

            @Override
            public void run() {
                ToolBarHuckel.this.handleStructureChanged((Structure)event.getSource());
            }
        });
    }

    @Override
    public void moleculeBondAdded(MoleculeEvent e) {
        final MoleculeEvent event = e;
        ThreadUtils.invokeAsSoonAsPossible(new Runnable(){

            @Override
            public void run() {
                ToolBarHuckel.this.handleStructureChanged((Structure)event.getSource());
            }
        });
    }

    @Override
    public void moleculeBondRemoved(MoleculeEvent e) {
        final MoleculeEvent event = e;
        ThreadUtils.invokeAsSoonAsPossible(new Runnable(){

            @Override
            public void run() {
                ToolBarHuckel.this.handleStructureChanged((Structure)event.getSource());
            }
        });
    }

    @Override
    public void moleculeChargeChanged(MoleculeEvent e) {
        final MoleculeEvent event = e;
        ThreadUtils.invokeAsSoonAsPossible(new Runnable(){

            @Override
            public void run() {
                ToolBarHuckel.this.handleStructureChanged((Structure)event.getSource());
            }
        });
    }

    @Override
    public void moleculeDeleted(MoleculeEvent e) {
    }

    @Override
    public void moleculeListHuckelAtomSeqNumAutoSetted(MoleculeEvent e) {
        final MoleculeEvent event = e;
        ThreadUtils.invokeAsSoonAsPossible(new Runnable(){

            @Override
            public void run() {
                ToolBarHuckel.this.handleStructureChanged((Structure)event.getSource());
            }
        });
    }

    @Override
    public void moleculeListHuckelAtomSeqNumReset(MoleculeEvent e) {
        final MoleculeEvent event = e;
        ThreadUtils.invokeAsSoonAsPossible(new Runnable(){

            @Override
            public void run() {
                ToolBarHuckel.this.handleStructureChanged((Structure)event.getSource());
            }
        });
    }

    @Override
    public void huckelAtomHxChanged(HuckelAtomEvent e) {
        final HuckelAtomEvent event = e;
        ThreadUtils.invokeAsSoonAsPossible(new Runnable(){

            @Override
            public void run() {
                ToolBarHuckel.this.handleStructureChanged((Structure)event.getSource().getMoleculeContainer());
            }
        });
    }

    @Override
    public void huckelAtomRadRChanged(HuckelAtomEvent e) {
    }

    @Override
    public void huckelAtomSeqNumChanged(HuckelAtomEvent e) {
        final HuckelAtomEvent event = e;
        ThreadUtils.invokeAsSoonAsPossible(new Runnable(){

            @Override
            public void run() {
                ToolBarHuckel.this.handleStructureChanged((Structure)event.getSource().getMoleculeContainer());
            }
        });
    }

    @Override
    public void huckelBondBondTypeChanged(HuckelBondEvent e) {
    }

    @Override
    public void huckelBondHxyChanged(HuckelBondEvent e) {
        final HuckelBondEvent event = e;
        ThreadUtils.invokeAsSoonAsPossible(new Runnable(){

            @Override
            public void run() {
                ToolBarHuckel.this.handleStructureChanged((Structure)event.getSource().getMoleculeContainer());
            }
        });
    }

    @Override
    public void monoExcitationTriggered(MonoExcitationEvent e) {
        final MonoExcitationEvent event = e;
        ThreadUtils.invokeAsSoonAsPossible(new Runnable(){

            @Override
            public void run() {
                ToolBarHuckel.this.handleStructureChanged(event.getSource().getStructure());
            }
        });
    }

    @Override
    public void structureLocalizedCoupleRemoved(StructureLocalizedEvent event) {
    }

    @Override
    public void structureLocalizedWeightChanged(StructureLocalizedEvent event) {
    }

    @Override
    public void structureLocalizedCoupleChanged(StructureLocalizedEvent event) {
    }

    @Override
    public void moleculeBlocDelocalizedAdded(MoleculeEvent event) {
    }

    @Override
    public void moleculeBlocDelocalizedRemoved(MoleculeEvent event) {
    }

    @Override
    public void blocDelocalizedHuckelObjectAdded(BlocDelocalizedEvent e) {
    }

    @Override
    public void blocDelocalizedHuckelObjectRemoved(BlocDelocalizedEvent e) {
    }

    @Override
    public void blocDelocalizedNbElectronsChanged(BlocDelocalizedEvent e) {
    }

    @Override
    public void mesomeryExceptionOccured(MesomeryEvent e, Exception exception) {
    }

    @Override
    public void mesomeryStartComputeWeights(MesomeryEvent event) {
    }

    @Override
    public void mesomeryStructuresSelectorChanged(MesomeryEvent event) {
    }
}

