/*
 * Decompiled with CFR 0.152.
 */
package views;

import controller.globalCommands.ActionStopConsumingProcess;
import controller.globalCommands.IGlobalCommands;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.ctom.hulis.huckel.Energy;
import org.ctom.hulis.huckel.Mesomery;
import org.ctom.hulis.huckel.comparators.MethodNameComparator;
import org.ctom.hulis.huckel.events.BlocDelocalizedEvent;
import org.ctom.hulis.huckel.events.HuckelAtomEvent;
import org.ctom.hulis.huckel.events.HuckelBondEvent;
import org.ctom.hulis.huckel.events.MesomeryEvent;
import org.ctom.hulis.huckel.events.MoleculeEvent;
import org.ctom.hulis.huckel.events.MonoExcitationEvent;
import org.ctom.hulis.huckel.events.StructureDelocalizedEvent;
import org.ctom.hulis.huckel.events.StructureEvent;
import org.ctom.hulis.huckel.events.StructureLocalizedEvent;
import org.ctom.hulis.huckel.exception.CoupleException;
import org.ctom.hulis.huckel.exception.IMethodException;
import org.ctom.hulis.huckel.exception.MesomeryNoStructureLocalizedException;
import org.ctom.hulis.huckel.exception.SelectionException;
import org.ctom.hulis.huckel.listeners.IMesomeryListener;
import org.ctom.hulis.huckel.methods.IMethod;
import org.ctom.hulis.huckel.selectors.MesomeryEnergyStructuresSelector;
import org.ctom.hulis.huckel.selectors.MesomeryHLPOverlapStructuresSelector;
import org.ctom.hulis.huckel.structures.Structure;
import org.ctom.hulis.huckel.structures.StructureLocalized;
import org.ctom.util.maths.Maths;
import util.DoubleJSlider;
import util.MyResourceBundle;
import util.SwingNumberFormater;
import util.ThreadUtils;
import util.io.SwingIO;
import util.languages.LanguageManager;
import views.FrameApp;
import views.IMesomeryReference;

public class ToolBarMesomery
extends JPanel
implements IMesomeryListener,
IMesomeryReference,
IGlobalCommands,
ChangeListener {
    public static final double DEFAULT_VALUE_SLIDER = 0.0;
    public static final double MAX_ENERGY_SLIDER = 0.0;
    public static final double MIN_ENERGY_SLIDER = -100.0;
    public static final DecimalFormat FORM = new DecimalFormat("#.#");
    protected static String lblBtResults;
    public static final int PRECISION = 2;
    protected String txtLblEmax = "";
    protected FrameApp app;
    public JButton btAutoGenStruct = new JButton();
    public JButton btStopAutoGenStruct = new JButton();
    public JToggleButton btChangeElectrons = new JToggleButton();
    public JToggleButton btCouple = new JToggleButton();
    public JToggleButton btBloc = new JToggleButton();
    public JButton btEndBloc = new JButton();
    public JButton btDuplicate = new JButton();
    public JButton btErase1 = new JButton();
    public JButton btEraseMesomery = new JButton();
    public JButton btShowResultsMesomery = new JButton();
    private MyResourceBundle bundle;
    public JLabel lblEnergy = new JLabel(this.txtLblEmax);
    public JLabel lblMesomery = new JLabel();
    public JLabel lblWeight = new JLabel();
    public JLabel lblOrder = new JLabel();
    protected Mesomery mesomery;
    public DoubleJSlider slider;
    private volatile boolean isWaiting = false;
    private boolean adjustSliderBecauseMaxValueForSelectionChanged = false;

    public ToolBarMesomery(FrameApp app, Mesomery mesomery) {
        this.app = app;
        this.mesomery = mesomery;
        mesomery.addListener(this);
        this.slider = new DoubleJSlider("", 0.0, -100.0, 0.0);
        this.slider.setToolTipText(null);
        this.slider.addChangeListener(this);
        this.distribute();
        this.updateLanguage();
        this.slider.setPrecision(2.0);
        this.slider.setOrientation(1);
        this.slider.setDoubleValue(-100.0);
    }

    public void calculated(MesomeryEvent e) {
        ThreadUtils.invokeAsSoonAsPossible(new Runnable(){

            @Override
            public void run() {
                ToolBarMesomery.this.updateInfoStructure(ToolBarMesomery.this.app.getCurrentMesomeryView().getCurrentStructure());
            }
        });
    }

    public TreeMap<Double, Integer> countStructsByEnergy() {
        TreeMap<Double, Integer> tblCountStructsByEnergy = new TreeMap<Double, Integer>();
        for (Structure s : this.mesomery.getAllStructures()) {
            Double e = Maths.round(s.getTotalEnergy().getBeta(), 2);
            try {
                Integer o = tblCountStructsByEnergy.get(e);
                if (o != null) {
                    tblCountStructsByEnergy.put(e, o + 1);
                    continue;
                }
                tblCountStructsByEnergy.put(e, 1);
            }
            catch (ClassCastException e1) {
                SwingIO.error(this.getClass().getName(), "TreeMap", "error slider !" + e1.getMessage(), e1);
                SwingIO.reportError(this.app);
            }
        }
        return tblCountStructsByEnergy;
    }

    public synchronized TreeMap<Double, Integer> countStructsByOverLap() {
        TreeMap<Double, Integer> tblCountStructsByOverlap = new TreeMap<Double, Integer>();
        for (StructureLocalized s : this.mesomery.getLocalizedStructures()) {
            Double e = Math.abs(Maths.round(s.getOverlapHLP(), 2));
            try {
                Integer o = tblCountStructsByOverlap.get(e);
                if (o != null) {
                    tblCountStructsByOverlap.put(e, o + 1);
                    continue;
                }
                tblCountStructsByOverlap.put(e, 1);
            }
            catch (ClassCastException e1) {
                SwingIO.error(this.getClass().getName(), "TreeMap", "error slider !" + e1.getMessage(), e1);
                SwingIO.reportError(this.app);
            }
        }
        return tblCountStructsByOverlap;
    }

    public void debug() {
        TreeMap<Double, Integer> tbl = this.countStructsByEnergy();
        if (tbl == null) {
            return;
        }
        SwingIO.PrintIf("*********** Count of structs by Energy **************");
        for (Double e : tbl.keySet()) {
            SwingIO.PrintIf("Energy : " + e + " beta --- count : " + tbl.get(e));
        }
    }

    public void distribute() {
        GridBagLayout repartiteur = new GridBagLayout();
        this.setLayout(repartiteur);
        GridBagConstraints contraintes = new GridBagConstraints();
        contraintes.gridx = 0;
        contraintes.gridy = 0;
        contraintes.insets = new Insets(0, 0, 5, 0);
        contraintes.gridwidth = 1;
        contraintes.gridheight = 1;
        contraintes.weightx = 0.0;
        contraintes.weighty = 0.0;
        contraintes.ipadx = 0;
        contraintes.ipady = 0;
        contraintes.fill = 1;
        contraintes.anchor = 11;
        this.add((Component)this.lblMesomery, contraintes);
        contraintes.gridx = 0;
        contraintes.gridy = 1;
        contraintes.insets = new Insets(0, 0, 0, 0);
        contraintes.gridwidth = 1;
        contraintes.gridheight = 1;
        contraintes.weightx = 0.0;
        contraintes.weighty = 0.0;
        contraintes.ipadx = 0;
        contraintes.ipady = 0;
        contraintes.fill = 2;
        contraintes.anchor = 10;
        this.add((Component)this.btAutoGenStruct, contraintes);
        this.add((Component)this.btStopAutoGenStruct, contraintes);
        this.btStopAutoGenStruct.setVisible(false);
        this.btAutoGenStruct.setVisible(true);
        contraintes.gridx = 0;
        contraintes.gridy = 2;
        contraintes.insets = new Insets(0, 0, 0, 0);
        contraintes.gridwidth = 1;
        contraintes.gridheight = 1;
        contraintes.weightx = 0.0;
        contraintes.weighty = 0.0;
        contraintes.ipadx = 0;
        contraintes.ipady = 0;
        contraintes.fill = 2;
        contraintes.anchor = 10;
        this.add((Component)this.btDuplicate, contraintes);
        contraintes.gridx = 0;
        contraintes.gridy = 3;
        contraintes.insets = new Insets(0, 0, 0, 0);
        contraintes.gridwidth = 1;
        contraintes.gridheight = 1;
        contraintes.weightx = 0.0;
        contraintes.weighty = 0.0;
        contraintes.ipadx = 0;
        contraintes.ipady = 0;
        contraintes.fill = 2;
        contraintes.anchor = 10;
        repartiteur.setConstraints(this.btChangeElectrons, contraintes);
        this.add((Component)this.btChangeElectrons, contraintes);
        contraintes.insets = new Insets(0, 0, 0, 0);
        contraintes.gridx = 0;
        contraintes.gridy = 4;
        contraintes.gridwidth = 1;
        contraintes.gridheight = 1;
        contraintes.weightx = 0.0;
        contraintes.weighty = 0.0;
        contraintes.ipadx = 0;
        contraintes.ipady = 0;
        contraintes.fill = 2;
        contraintes.anchor = 10;
        this.add((Component)this.btCouple, contraintes);
        this.btCouple.setVisible(this.app.isExpertMode());
        contraintes.insets = new Insets(0, 0, 0, 0);
        contraintes.gridx = 0;
        contraintes.gridy = 5;
        contraintes.gridwidth = 1;
        contraintes.gridheight = 1;
        contraintes.weightx = 0.0;
        contraintes.weighty = 0.0;
        contraintes.ipadx = 0;
        contraintes.ipady = 0;
        contraintes.fill = 2;
        contraintes.anchor = 10;
        this.add((Component)this.btBloc, contraintes);
        this.btBloc.setVisible(this.app.isExpertMode());
        contraintes.insets = new Insets(0, 0, 0, 0);
        contraintes.gridx = 0;
        contraintes.gridy = 6;
        contraintes.gridwidth = 1;
        contraintes.gridheight = 1;
        contraintes.weightx = 0.0;
        contraintes.weighty = 0.0;
        contraintes.ipadx = 0;
        contraintes.ipady = 0;
        contraintes.fill = 2;
        contraintes.anchor = 10;
        this.add((Component)this.btEndBloc, contraintes);
        this.btEndBloc.setVisible(false);
        contraintes.insets = new Insets(0, 10, 0, 0);
        contraintes.gridx = 0;
        contraintes.gridy = 7;
        contraintes.gridwidth = 1;
        contraintes.gridheight = 1;
        contraintes.weightx = 0.0;
        contraintes.weighty = 0.0;
        contraintes.ipadx = 0;
        contraintes.ipady = 0;
        contraintes.fill = 2;
        contraintes.anchor = 10;
        this.add((Component)this.lblEnergy, contraintes);
        contraintes.insets = new Insets(0, 10, 0, 0);
        contraintes.gridx = 0;
        contraintes.gridy = 8;
        contraintes.gridwidth = 1;
        contraintes.gridheight = 1;
        contraintes.weightx = 0.0;
        contraintes.weighty = 0.0;
        contraintes.ipadx = 0;
        contraintes.ipady = 0;
        contraintes.fill = 2;
        contraintes.anchor = 10;
        this.add((Component)this.lblWeight, contraintes);
        contraintes = new GridBagConstraints();
        contraintes.insets = new Insets(0, 0, 0, 0);
        contraintes.gridx = 0;
        contraintes.gridy = 9;
        contraintes.gridwidth = 1;
        contraintes.gridheight = 1;
        contraintes.weightx = 0.0;
        contraintes.weighty = 0.0;
        contraintes.ipadx = 0;
        contraintes.ipady = 0;
        contraintes.fill = 2;
        contraintes.anchor = 10;
        this.add((Component)this.btShowResultsMesomery, contraintes);
        contraintes = new GridBagConstraints();
        contraintes.insets = new Insets(5, 50, 0, 0);
        contraintes.gridx = 0;
        contraintes.gridy = 10;
        contraintes.gridwidth = 1;
        contraintes.gridheight = 1;
        contraintes.weightx = 0.0;
        contraintes.weighty = 0.0;
        contraintes.ipadx = 0;
        contraintes.ipady = 0;
        contraintes.fill = 2;
        contraintes.anchor = 10;
        this.add((Component)this.lblOrder, contraintes);
        contraintes = new GridBagConstraints();
        contraintes.insets = new Insets(0, 0, 0, 0);
        contraintes.gridx = 0;
        contraintes.gridy = 11;
        contraintes.gridwidth = 1;
        contraintes.gridheight = 19;
        contraintes.weightx = 0.0;
        contraintes.weighty = 1.0;
        contraintes.fill = 3;
        contraintes.anchor = 10;
        contraintes.ipadx = 0;
        contraintes.ipady = 0;
        this.add((Component)this.slider, contraintes);
        contraintes.insets = new Insets(0, 0, 0, 0);
        contraintes.gridx = 0;
        contraintes.gridy = 30;
        contraintes.gridwidth = 1;
        contraintes.gridheight = 1;
        contraintes.weightx = 0.0;
        contraintes.weighty = 0.0;
        contraintes.ipadx = 0;
        contraintes.ipady = 0;
        contraintes.fill = 2;
        contraintes.anchor = 10;
        this.add((Component)this.btErase1, contraintes);
        contraintes.insets = new Insets(0, 0, 0, 0);
        contraintes.gridx = 0;
        contraintes.gridy = 31;
        contraintes.gridwidth = 1;
        contraintes.gridheight = 1;
        contraintes.weightx = 0.0;
        contraintes.weighty = 0.0;
        contraintes.ipadx = 0;
        contraintes.ipady = 0;
        contraintes.fill = 2;
        contraintes.anchor = 10;
        repartiteur.setConstraints(this.btEraseMesomery, contraintes);
        this.add((Component)this.btEraseMesomery, contraintes);
    }

    public void adjustSlider(double value) {
        this.slider.removeChangeListener(this);
        this.slider.setDoubleValue(value);
        this.slider.addChangeListener(this);
    }

    @Override
    public Insets getInsets() {
        return new Insets(10, 0, 10, 0);
    }

    @Override
    public Mesomery getMesomery() {
        return this.mesomery;
    }

    public DoubleJSlider getSlider() {
        return this.slider;
    }

    public void refresh() {
        this.updateLanguage();
        this.refreshSlider();
        this.updateInfoStructure(this.app.getCurrentMesomeryView().getCurrentStructure());
    }

    public void refreshSlider() {
        this.slider.removeChangeListener(this);
        this.slider.setValueIsAdjusting(false);
        if (this.app.getCurrentMesomery().getStructureSelector() instanceof MesomeryHLPOverlapStructuresSelector) {
            this.refreshSliderHLP();
        } else {
            this.refreshSliderHLCI();
        }
        this.slider.addChangeListener(this);
    }

    private void refreshSliderHLP() {
        TreeMap<Double, Integer> tbl = this.countStructsByOverLap();
        if (tbl == null) {
            return;
        }
        Hashtable<Integer, JLabel> labels = new Hashtable<Integer, JLabel>();
        if (!tbl.isEmpty()) {
            double min = -tbl.lastKey().doubleValue();
            double max = -tbl.firstKey().doubleValue();
            for (Double e : tbl.keySet()) {
                labels.put((int)(-e.doubleValue() * Math.pow(10.0, 2.0)), new JLabel("<html><head><style type=\"text/css\">.couleur0 {font-family:\"Arial\"; font-size:8px;} .couleur{font-family:\"Arial\"; font-size:8px; color: #FF0000;}</style></head><body><span class=\"couleur0\">" + e + " </span><span class=\"couleur\">(" + tbl.get(e) + ")</span></body></head></html>"));
            }
            if (min == max) {
                max = 0.0;
            }
            this.slider.setDoubleMinimum(min);
            this.slider.setDoubleMaximum(max);
            this.slider.setLabelTable(labels);
            this.slider.setDoubleMajorTickSpacing(5.0 * Math.pow(10.0, -1.0));
            this.slider.setPaintLabels(true);
            this.slider.setPaintTicks(false);
        } else {
            this.slider.setPaintLabels(false);
        }
    }

    private void refreshSliderHLCI() {
        TreeMap<Double, Integer> tbl = this.countStructsByEnergy();
        if (tbl == null) {
            return;
        }
        Hashtable<Integer, JLabel> labels = new Hashtable<Integer, JLabel>();
        if (!tbl.isEmpty()) {
            double min = -tbl.lastKey().doubleValue();
            double max = -tbl.firstKey().doubleValue();
            for (Double e : tbl.keySet()) {
                if (e == -min && tbl.get(e) < 2) {
                    labels.put((int)(-e.doubleValue() * Math.pow(10.0, 2.0)), new JLabel("<html><head><style type=\"text/css\">.couleur0 {font-family:\"Arial\"; font-size:8px;} .couleur{font-family:\"Arial\"; font-size:8px; color: #FF0000;}</style></head><body><span class=\"couleur0\">" + new Energy(0.0, e).betaToString() + " </span><span class=\"couleur\">(" + this.bundle.getString("phi") + "<sub>" + "tot" + "</sub>)</span></body></head></html>"));
                    continue;
                }
                labels.put((int)(-e.doubleValue() * Math.pow(10.0, 2.0)), new JLabel("<html><head><style type=\"text/css\">.couleur0 {font-family:\"Arial\"; font-size:8px;} .couleur{font-family:\"Arial\"; font-size:8px; color: #FF0000;}</style></head><body><span class=\"couleur0\">" + new Energy(0.0, e).betaToString() + " </span><span class=\"couleur\">(" + tbl.get(e) + ")</span></body></head></html>"));
            }
            if (min == max) {
                max = 0.0;
            }
            if (min == 0.0 && max == 0.0) {
                max = 1.0;
            }
            this.slider.setDoubleMinimum(min);
            this.slider.setDoubleMaximum(max);
            this.slider.setLabelTable(labels);
            this.slider.setDoubleMajorTickSpacing(5.0 * Math.pow(10.0, -1.0));
            this.slider.setPaintLabels(true);
            this.slider.setPaintTicks(true);
        } else {
            this.slider.setPaintLabels(false);
        }
    }

    public void setBackgroundColor(Color bg) {
        super.setBackground(bg);
        this.slider.setBackground(bg);
    }

    public void setFonts() {
        Font btFont = (Font)this.bundle.getObject("font");
        Font btFont3 = new Font("Helvetica", 0, 11);
        Font btFont4 = new Font("Helvetica", 1, 11);
        this.lblEnergy.setFont(btFont3);
        this.btAutoGenStruct.setFont(btFont);
        this.btStopAutoGenStruct.setFont(btFont);
        this.btDuplicate.setFont(btFont);
        this.btChangeElectrons.setFont(btFont);
        this.btCouple.setFont(btFont);
        this.btBloc.setFont(btFont);
        this.btEndBloc.setFont(btFont);
        this.btShowResultsMesomery.setFont(btFont);
        this.btErase1.setFont(btFont);
        this.btEraseMesomery.setFont(btFont);
        this.btAutoGenStruct.setOpaque(false);
        this.btStopAutoGenStruct.setOpaque(false);
        this.btDuplicate.setOpaque(false);
        this.btChangeElectrons.setOpaque(false);
        this.btCouple.setOpaque(false);
        this.btBloc.setOpaque(false);
        this.btEndBloc.setOpaque(false);
        this.btShowResultsMesomery.setOpaque(false);
        this.btErase1.setOpaque(false);
        this.btEraseMesomery.setOpaque(false);
        this.lblOrder.setFont(btFont3);
        this.lblWeight.setFont(btFont4);
        this.lblWeight.setForeground(Color.RED);
        this.lblMesomery.setHorizontalAlignment(0);
        this.lblMesomery.setPreferredSize(new Dimension((int)this.getPreferredSize().getWidth(), 55));
        this.lblMesomery.setOpaque(true);
        this.lblMesomery.setBackground(new Color(255, 102, 0));
    }

    public void updateLanguage() {
        this.bundle = LanguageManager.getInstance().getResource("ToolBarMesomery");
        this.txtLblEmax = "<html>" + this.bundle.getString("kenergy") + "<sub>" + "tot" + "</sub> =</html>";
        lblBtResults = this.bundle.getString("kresults");
        this.lblMesomery.setText(this.bundle.getString("kmesomery"));
        this.btAutoGenStruct.setText(this.bundle.getString("kgenerateall"));
        this.btStopAutoGenStruct.setText("STOP");
        this.btDuplicate.setText(this.bundle.getString("kcreate1"));
        this.btChangeElectrons.setText(this.bundle.getString("kchangebonds"));
        this.btCouple.setText(this.bundle.getString("kcouple"));
        this.btBloc.setText(this.bundle.getString("kbloc"));
        this.btEndBloc.setText(this.bundle.getString("kendbloc"));
        this.btCouple.setText(this.bundle.getString("kcouple"));
        this.btShowResultsMesomery.setText(this.bundle.getString("kresults"));
        this.btErase1.setText(this.bundle.getString("kerase1"));
        this.btEraseMesomery.setText(this.bundle.getString("kerasem"));
        this.lblEnergy.setText(this.txtLblEmax);
        this.setFonts();
        Structure s = null;
        if (this.app.getCurrentMesomeryView() != null) {
            s = this.app.getCurrentMesomeryView().getCurrentStructure();
        }
        this.updateInfoStructure(s);
    }

    @Override
    public void setMesomery(Mesomery mesomery) {
        this.mesomery.removeListener(this);
        this.mesomery = mesomery;
        this.mesomery.addListener(this);
        this.refresh();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource().equals(this.slider)) {
            if (this.slider.getValueIsAdjusting() || this.adjustSliderBecauseMaxValueForSelectionChanged) {
                this.adjustSliderBecauseMaxValueForSelectionChanged = false;
                return;
            }
            if (this.mesomery == null) {
                return;
            }
            if (this.mesomery.getDelocalizedStructure() == null) {
                return;
            }
            final double treshold = -this.slider.getDoubleValue();
            SwingIO.log(this.getClass().getName(), "stateChanged", "adjust slider to treshold = " + treshold);
            this.app.registerAction("Slider");
            this.slider.setEnabled(false);
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Thread stop = ActionStopConsumingProcess.stopCalculateWeights(ToolBarMesomery.this.app);
                        stop.join();
                        ThreadUtils.invokeAsSoonAsPossible(new Runnable(){

                            @Override
                            public void run() {
                                (this).ToolBarMesomery.this.slider.setEnabled(true);
                            }
                        });
                        ToolBarMesomery.this.mesomery.setSelectionTreshold(treshold);
                    }
                    catch (CoupleException e1) {
                        final CoupleException exception = e1;
                        ThreadUtils.invokeAsSoonAsPossible(new Runnable(){

                            @Override
                            public void run() {
                                SwingIO.error(this.getClass().getName(), "insertTXT", exception.getMessage(), exception);
                                SwingIO.reportError((this).ToolBarMesomery.this.app);
                            }
                        });
                    }
                    catch (IMethodException e1) {
                        final IMethodException exception = e1;
                        ThreadUtils.invokeAsSoonAsPossible(new Runnable(){

                            @Override
                            public void run() {
                                SwingIO.error(this.getClass().getName(), "insertTXT", exception.getMessage(), exception);
                                SwingIO.reportError((this).ToolBarMesomery.this.app);
                            }
                        });
                    }
                    catch (MesomeryNoStructureLocalizedException e1) {
                        final MesomeryNoStructureLocalizedException exception = e1;
                        ThreadUtils.invokeAsSoonAsPossible(new Runnable(){

                            @Override
                            public void run() {
                                SwingIO.error(this.getClass().getName(), "insertTXT", exception.getMessage(), exception);
                                SwingIO.reportError((this).ToolBarMesomery.this.app);
                            }
                        });
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    catch (SelectionException e) {
                        e.printStackTrace();
                    }
                }
            }).start();
        }
    }

    public void updateInfoStructure(Structure s) {
        if (s instanceof StructureLocalized) {
            this.lblEnergy.setText("<html>E<sub>" + s.getName() + "</sub> = " + s.getTotalEnergy() + "</html>");
            if (((StructureLocalized)s).getError() == StructureLocalized.Error.ERROR_INCORRECT_NB_PI_ELEC) {
                this.lblWeight.setText("<html>" + this.bundle.getString("phi") + "<sub>" + s.getName() + "</sub> " + this.bundle.getString("kincomplete") + "</html>");
            } else if (((StructureLocalized)s).getError() == StructureLocalized.Error.ERROR_ALREADY_EXIST) {
                this.lblWeight.setText("<html>w<sub>" + s.getName() + "</sub> " + this.bundle.getString("exist") + "</html>");
            } else if (this.mesomery.listIncorrectStructPiElecNumber().isEmpty()) {
                IMethod[] methods = this.mesomery.getMethods();
                Arrays.sort(methods, new MethodNameComparator());
                if (methods == null) {
                    this.lblWeight.setText("<html>&nbsp;<br>&nbsp;<br></html>");
                } else {
                    String txtW = "";
                    if (this.mesomery.isCalculatingWeights()) {
                        Thread waitThread = new Thread(new Runnable(){

                            @Override
                            public void run() {
                                int nbPoints = 1;
                                final String txtCompute = ToolBarMesomery.this.bundle.getString("compute");
                                ToolBarMesomery.this.isWaiting = true;
                                while (ToolBarMesomery.this.mesomery.isCalculatingWeights()) {
                                    nbPoints = nbPoints % 10 + 1;
                                    String strPoints = "";
                                    int i2 = 0;
                                    while (i2 < nbPoints) {
                                        strPoints = String.valueOf(strPoints) + ".";
                                        ++i2;
                                    }
                                    final String strPointsToDisplay = strPoints;
                                    ThreadUtils.invokeAsSoonAsPossible(new Runnable(){

                                        @Override
                                        public void run() {
                                            if ((this).ToolBarMesomery.this.mesomery.isCalculatingWeights()) {
                                                (this).ToolBarMesomery.this.lblWeight.setText(String.valueOf(txtCompute) + strPointsToDisplay);
                                            }
                                        }
                                    });
                                    try {
                                        Thread.sleep(1000L);
                                    }
                                    catch (InterruptedException e) {
                                        e.printStackTrace();
                                    }
                                }
                                ToolBarMesomery.this.isWaiting = false;
                            }
                        });
                        if (!this.isWaiting) {
                            waitThread.start();
                        }
                    } else {
                        IMethod[] iMethodArray = methods;
                        int n = methods.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IMethod method = iMethodArray[n2];
                            if (method.getWeights().length != 0) {
                                if (txtW != "") {
                                    txtW = String.valueOf(txtW) + "<br>";
                                }
                                String methodName = method.getName();
                                txtW = String.valueOf(txtW) + "w<sub>" + s.getName() + "</sub> = " + SwingNumberFormater.doubleToString(((StructureLocalized)s).getWeight(methodName) * 100.0, FORM, "%") + "(" + methodName + ")";
                            }
                            ++n2;
                        }
                        this.lblWeight.setText("<html>" + txtW + "</html>");
                    }
                }
            } else {
                this.lblWeight.setText("<html>&nbsp;<br>&nbsp;<br></html>");
            }
        } else {
            if (this.mesomery.countSelectedLocalizedStructs() == 0 || !this.mesomery.listIncorrectStructPiElecNumber().isEmpty()) {
                this.lblEnergy.setText("");
                this.lblWeight.setText("<html>&nbsp;<br>&nbsp;<br></html");
                return;
            }
            IMethod[] methods = this.mesomery.getMethods();
            Arrays.sort(methods, new MethodNameComparator());
            if (methods == null) {
                this.lblEnergy.setText("");
            } else {
                String tau = "";
                IMethod[] iMethodArray = methods;
                int n = methods.length;
                int n3 = 0;
                while (n3 < n) {
                    IMethod method = iMethodArray[n3];
                    String methodName = method.getName();
                    if (this.mesomery.getMethod(methodName).isImplementedTau()) {
                        if (tau != "") {
                            tau = String.valueOf(tau) + "<br>";
                        }
                        tau = String.valueOf(tau) + "\u03c4<sub>" + method.getName() + "</sub>" + " = " + SwingNumberFormater.doubleToString(this.mesomery.getMethod(methodName).getTau() * 100.0, FORM, "%");
                    }
                    ++n3;
                }
                this.lblEnergy.setText("<html>" + tau + "</html>");
            }
            this.lblWeight.setText("<html>n<sub>CI</sub> = " + this.mesomery.countSelectedLocalizedStructs() + "</html>");
        }
    }

    @Override
    public void mesomeryStructuresSelectionTresholdChanged(MesomeryEvent e) {
        this.adjustSliderBecauseMaxValueForSelectionChanged = true;
        this.slider.setDoubleValue(-((Double)e.getNewValue()).doubleValue());
    }

    public synchronized void setValueManually(double value) {
        try {
            this.mesomery.setSelectionTreshold(-value);
        }
        catch (SelectionException e) {
            e.printStackTrace();
        }
        catch (CoupleException e) {
            e.printStackTrace();
        }
        catch (IMethodException e) {
            e.printStackTrace();
        }
        catch (MesomeryNoStructureLocalizedException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void mesomeryListWeightCalculated(MesomeryEvent e) {
        ThreadUtils.invokeAsSoonAsPossible(new Runnable(){

            @Override
            public void run() {
                ToolBarMesomery.this.refresh();
            }
        });
    }

    @Override
    public void mesomeryMethodAdded(MesomeryEvent e) {
        ThreadUtils.invokeAsSoonAsPossible(new Runnable(){

            @Override
            public void run() {
                ToolBarMesomery.this.refresh();
            }
        });
    }

    @Override
    public void mesomeryMethodRemoved(MesomeryEvent e) {
        ThreadUtils.invokeAsSoonAsPossible(new Runnable(){

            @Override
            public void run() {
                ToolBarMesomery.this.refresh();
            }
        });
    }

    @Override
    public void mesomeryStructureAdded(MesomeryEvent e) {
        ThreadUtils.invokeAsSoonAsPossible(new Runnable(){

            @Override
            public void run() {
                ToolBarMesomery.this.refreshSlider();
                ToolBarMesomery.this.adjustSlider(-((Double)ToolBarMesomery.this.mesomery.getSelectionTreshold()).doubleValue());
            }
        });
    }

    public void handleStructureChanged(Structure s) {
        this.refreshSlider();
        if (this.mesomery.getStructureSelector().isCurrentValueLowerThanTreshold(s) && s == this.app.getCurrentMesomeryView().getCurrentStructure()) {
            this.adjustSlider(-((Double)this.mesomery.getStructureSelector().getCurrentValue(s)).doubleValue());
        }
        this.updateInfoStructure(s);
    }

    @Override
    public void mesomeryStructureRemoved(MesomeryEvent e) {
        ThreadUtils.invokeAsSoonAsPossible(new Runnable(){

            @Override
            public void run() {
                if (ToolBarMesomery.this.mesomery.countLocalizedStructs() == 0) {
                    ToolBarMesomery.this.slider.setDoubleValue(0.0);
                }
                ToolBarMesomery.this.updateInfoStructure(ToolBarMesomery.this.app.getCurrentMesomeryView().getCurrentStructure());
                ToolBarMesomery.this.refreshSlider();
                if (ToolBarMesomery.this.app.getCurrentMesomeryView().countDisplayedStructures() > 0) {
                    ToolBarMesomery.this.updateInfoStructure(ToolBarMesomery.this.app.getCurrentMesomeryView().getCurrentStructure());
                }
            }
        });
    }

    @Override
    public void structureDelocalizedSpinChanged(StructureDelocalizedEvent event) {
    }

    @Override
    public void structureNameChanged(StructureEvent event) {
    }

    @Override
    public void moleculeAtomAdded(MoleculeEvent e) {
        final MoleculeEvent event = e;
        ThreadUtils.invokeAsSoonAsPossible(new Runnable(){

            @Override
            public void run() {
                ToolBarMesomery.this.handleStructureChanged((Structure)event.getSource());
            }
        });
    }

    @Override
    public void moleculeAtomRemoved(MoleculeEvent e) {
        final MoleculeEvent event = e;
        ThreadUtils.invokeAsSoonAsPossible(new Runnable(){

            @Override
            public void run() {
                ToolBarMesomery.this.handleStructureChanged((Structure)event.getSource());
            }
        });
    }

    @Override
    public void moleculeAtomReplaced(MoleculeEvent e) {
        final MoleculeEvent event = e;
        ThreadUtils.invokeAsSoonAsPossible(new Runnable(){

            @Override
            public void run() {
                ToolBarMesomery.this.handleStructureChanged((Structure)event.getSource());
            }
        });
    }

    @Override
    public void moleculeBondAdded(MoleculeEvent e) {
        final MoleculeEvent event = e;
        ThreadUtils.invokeAsSoonAsPossible(new Runnable(){

            @Override
            public void run() {
                ToolBarMesomery.this.handleStructureChanged((Structure)event.getSource());
            }
        });
    }

    @Override
    public void moleculeBondRemoved(MoleculeEvent e) {
        final MoleculeEvent event = e;
        ThreadUtils.invokeAsSoonAsPossible(new Runnable(){

            @Override
            public void run() {
                ToolBarMesomery.this.handleStructureChanged((Structure)event.getSource());
            }
        });
    }

    @Override
    public void moleculeChargeChanged(MoleculeEvent e) {
        final MoleculeEvent event = e;
        ThreadUtils.invokeAsSoonAsPossible(new Runnable(){

            @Override
            public void run() {
                ToolBarMesomery.this.handleStructureChanged((Structure)event.getSource());
            }
        });
    }

    @Override
    public void moleculeDeleted(MoleculeEvent e) {
    }

    @Override
    public void moleculeListHuckelAtomSeqNumAutoSetted(MoleculeEvent e) {
        final MoleculeEvent event = e;
        ThreadUtils.invokeAsSoonAsPossible(new Runnable(){

            @Override
            public void run() {
                ToolBarMesomery.this.handleStructureChanged((Structure)event.getSource());
            }
        });
    }

    @Override
    public void moleculeListHuckelAtomSeqNumReset(MoleculeEvent e) {
        final MoleculeEvent event = e;
        ThreadUtils.invokeAsSoonAsPossible(new Runnable(){

            @Override
            public void run() {
                ToolBarMesomery.this.handleStructureChanged((Structure)event.getSource());
            }
        });
    }

    @Override
    public void huckelAtomHxChanged(HuckelAtomEvent e) {
        final HuckelAtomEvent event = e;
        ThreadUtils.invokeAsSoonAsPossible(new Runnable(){

            @Override
            public void run() {
                ToolBarMesomery.this.handleStructureChanged((Structure)event.getSource().getMoleculeContainer());
            }
        });
    }

    @Override
    public void huckelAtomRadRChanged(HuckelAtomEvent e) {
        final HuckelAtomEvent event = e;
        ThreadUtils.invokeAsSoonAsPossible(new Runnable(){

            @Override
            public void run() {
                ToolBarMesomery.this.handleStructureChanged((Structure)event.getSource().getMoleculeContainer());
            }
        });
    }

    @Override
    public void huckelAtomSeqNumChanged(HuckelAtomEvent e) {
        final HuckelAtomEvent event = e;
        ThreadUtils.invokeAsSoonAsPossible(new Runnable(){

            @Override
            public void run() {
                ToolBarMesomery.this.handleStructureChanged((Structure)event.getSource().getMoleculeContainer());
            }
        });
    }

    @Override
    public void huckelBondBondTypeChanged(HuckelBondEvent e) {
        final HuckelBondEvent event = e;
        ThreadUtils.invokeAsSoonAsPossible(new Runnable(){

            @Override
            public void run() {
                ToolBarMesomery.this.handleStructureChanged((Structure)event.getSource().getMoleculeContainer());
            }
        });
    }

    @Override
    public void huckelBondHxyChanged(HuckelBondEvent e) {
        final HuckelBondEvent event = e;
        ThreadUtils.invokeAsSoonAsPossible(new Runnable(){

            @Override
            public void run() {
                ToolBarMesomery.this.handleStructureChanged((Structure)event.getSource().getMoleculeContainer());
            }
        });
    }

    @Override
    public void monoExcitationTriggered(MonoExcitationEvent e) {
        final MonoExcitationEvent event = e;
        ThreadUtils.invokeAsSoonAsPossible(new Runnable(){

            @Override
            public void run() {
                ToolBarMesomery.this.handleStructureChanged(event.getSource().getStructure());
            }
        });
    }

    @Override
    public void structureLocalizedCoupleRemoved(StructureLocalizedEvent event) {
    }

    @Override
    public void structureLocalizedWeightChanged(StructureLocalizedEvent event) {
    }

    @Override
    public void structureLocalizedCoupleChanged(StructureLocalizedEvent event) {
    }

    @Override
    public void moleculeBlocDelocalizedAdded(MoleculeEvent event) {
        ThreadUtils.invokeAsSoonAsPossible(new Runnable(){

            @Override
            public void run() {
                ToolBarMesomery.this.refresh();
            }
        });
    }

    @Override
    public void moleculeBlocDelocalizedRemoved(MoleculeEvent event) {
        ThreadUtils.invokeAsSoonAsPossible(new Runnable(){

            @Override
            public void run() {
                ToolBarMesomery.this.refresh();
            }
        });
    }

    @Override
    public void blocDelocalizedHuckelObjectAdded(BlocDelocalizedEvent e) {
    }

    @Override
    public void blocDelocalizedHuckelObjectRemoved(BlocDelocalizedEvent e) {
        final BlocDelocalizedEvent event = e;
        ThreadUtils.invokeAsSoonAsPossible(new Runnable(){

            @Override
            public void run() {
                ToolBarMesomery.this.handleStructureChanged((Structure)event.getSource().getMoleculeParent());
            }
        });
    }

    @Override
    public void blocDelocalizedNbElectronsChanged(BlocDelocalizedEvent e) {
        final BlocDelocalizedEvent event = e;
        ThreadUtils.invokeAsSoonAsPossible(new Runnable(){

            @Override
            public void run() {
                ToolBarMesomery.this.handleStructureChanged((Structure)event.getSource().getMoleculeParent());
            }
        });
    }

    @Override
    public void mesomeryExceptionOccured(MesomeryEvent e, Exception exception) {
    }

    @Override
    public void mesomeryStartComputeWeights(MesomeryEvent event) {
        this.updateInfoStructure(this.app.getCurrentMesomeryView().getCurrentStructure());
    }

    @Override
    public void mesomeryStructuresSelectorChanged(MesomeryEvent event) {
        if (event.getNewValue() instanceof MesomeryEnergyStructuresSelector) {
            this.lblOrder.setText("<html>E<sub>i</sub></html>");
        } else if (event.getNewValue() instanceof MesomeryHLPOverlapStructuresSelector) {
            this.lblOrder.setText("<html>&#60;\u03c8<sub>tot</sub>|\u03c8<sub>i</sub>&#62;</html>");
        }
    }
}

