/*
 * Decompiled with CFR 0.152.
 */
package views.prefs;

import java.util.Locale;
import util.IPreferences;
import util.MyLocale;
import util.PreferencesMap;

public final class PreferencesGUI {
    public static final boolean CLEAR_PREFERENCES_WHEN_START = false;
    public static final boolean MANAGE_LICENCE = true;
    public static final int RESULTS_PRECISION_MO_DEFAULT = 2;
    public static final int RESULTS_PRECISION_ENERGIES_DEFAULT = 2;
    public static final boolean DISPLAY_ATOMS_CIRCLES_DEFAULT = true;
    public static final boolean VERBOSE_DEFAULT = false;
    public static final boolean DISPLAY_ATOMS_SYMBOLS_DEFAULT = true;
    private static final boolean CHECK_VERSION_DEFAULT = true;
    private static final boolean SEND_INFORMATION_DEFAULT = true;
    private static final int TOTAL_USE_DEFAULT = 0;
    private static double SCALE_ORB_DEFAULT = 4.0;
    private static boolean SHOWSYMMETRY = false;
    private static boolean printingSet = false;
    private static String radicalPrint = "";
    private static String extPrint = "";
    private static String dirPrint = "";
    private static PreferencesGUI instance;
    private static boolean superMario;
    private IPreferences prefs = new PreferencesMap();
    private boolean devMode = true;

    static {
        superMario = true;
    }

    public static void setPrinting(String dirPrint, String radicalPrint, String extPrint) {
        PreferencesGUI.dirPrint = dirPrint;
        PreferencesGUI.radicalPrint = radicalPrint;
        PreferencesGUI.extPrint = extPrint;
        printingSet = true;
    }

    public static String getDirPrint() {
        return dirPrint;
    }

    public static String getExtPrint() {
        return extPrint;
    }

    public static boolean isPrintingSet() {
        return printingSet;
    }

    public static String getRadicalPrint() {
        return radicalPrint;
    }

    public static double getScaleOrbDefault() {
        return SCALE_ORB_DEFAULT;
    }

    public static PreferencesGUI getInstance() {
        if (instance == null) {
            instance = new PreferencesGUI();
        }
        return instance;
    }

    private PreferencesGUI() {
    }

    public void setPreferencesManager(IPreferences preferences) {
        this.prefs = preferences;
    }

    public static void setSuperMario(boolean b) {
        superMario = b;
    }

    public static boolean getSuperMario() {
        return superMario;
    }

    public static void switchSuperMario() {
        PreferencesGUI.setSuperMario(!PreferencesGUI.getSuperMario());
    }

    public double getSCALE_ORB() {
        return this.prefs.getDouble("SCALE_ORB", SCALE_ORB_DEFAULT);
    }

    public void setSCALE_ORB(double sCALE_ORB) {
        this.prefs.putDouble("SCALE_ORB", sCALE_ORB);
    }

    public int getResultsPrecisionEnergies() {
        return this.prefs.getInt("resultsPrecisionEnergies", 2);
    }

    public int getResultsPrecisionMO() {
        return this.prefs.getInt("resultsPrecisionMO", 2);
    }

    public boolean isDisplayAtomsCircles() {
        return this.prefs.getBoolean("isDisplayAtomsCircles", true);
    }

    public boolean isDisplayAtomsSymbols() {
        return this.prefs.getBoolean("isDisplayAtomsSymbols", true);
    }

    public void setResultsPrecisionMO(int precisionMO) {
        this.prefs.putInt("resultsPrecisionMO", precisionMO);
    }

    public void setResultsPrecisionEnergies(int precisionEnergies) {
        this.prefs.putInt("resultsPrecisionEnergies", precisionEnergies);
    }

    public void setDisplayAtomsCircles(boolean selected) {
        this.prefs.putBoolean("isDisplayAtomsCircles", selected);
    }

    public void setVerbose(boolean selected) {
        this.prefs.putBoolean("isVerbose", selected);
    }

    public void setDisplayAtomsSymbols(boolean selected) {
        this.prefs.putBoolean("isDisplayAtomsSymbols", selected);
    }

    public void setLanguage(Locale locale) {
        this.prefs.putString("language", locale.getLanguage().toString());
    }

    public void setAcceptLicense(boolean accept) {
        this.prefs.putBoolean("acceptLicense", accept);
    }

    public void setCheckVersion(boolean isCheckVersion) {
        this.prefs.putBoolean("isCheckVersion", isCheckVersion);
    }

    public void setSendInformation(boolean isSendInformation) {
        this.prefs.putBoolean("isSendInformation", isSendInformation);
    }

    public void setTotalUse(int totalUse) {
        this.prefs.putInt("totalUse", totalUse);
    }

    public boolean isLicenseAlreadyAccepted() {
        return this.prefs.getBoolean("acceptLicense", false);
    }

    public void clearPreferences() {
        this.prefs.clear();
    }

    public boolean isCheckVersion() {
        return this.prefs.getBoolean("isCheckVersion", true);
    }

    public boolean isSendInformation() {
        return this.prefs.getBoolean("isSendInformation", true);
    }

    public int getTotalUse() {
        return this.prefs.getInt("totalUse", 0);
    }

    public Locale getLanguage() {
        return new Locale(this.prefs.getString("language", MyLocale.getDefault().getLanguage()));
    }

    public static boolean isSHOWSYMMETRY() {
        return SHOWSYMMETRY;
    }

    public static void setSHOWSYMMETRY(boolean sHOWSYMMETRY) {
        SHOWSYMMETRY = sHOWSYMMETRY;
    }

    public boolean isDevMode() {
        return this.devMode;
    }

    public void setDevMode(boolean b) {
        this.devMode = b;
    }
}

